<?php
$files = glob("../data/*.json");
$users = [];
foreach ($files as $file) {
    $content = file_get_contents($file);
    $data = json_decode($content, true);
    $data['uid'] = basename($file, '.json');
    $users[] = $data;
}
usort($users, function($a, $b) {
    return $b['last_seen'] - $a['last_seen'];
});
echo json_encode($users);
?>